<?php
// generar_hash.php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $clave_plana = $_POST['clave'] ?? '';
    if ($clave_plana) {
        $hash = password_hash($clave_plana, PASSWORD_BCRYPT);
        echo "<p><strong>Contraseña encriptada:</strong></p>";
        echo "<textarea style='width:100%;height:60px;'>$hash</textarea>";
        exit;
    } else {
        echo "<p style='color:red;'>Por favor ingresa una contraseña.</p>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Generador de Hash</title>
</head>
<body style="font-family: sans-serif; max-width: 500px; margin: 50px auto;">
    <h2>Generar contraseña encriptada (bcrypt)</h2>
    <form method="post">
        <label>Contraseña en texto plano:</label><br>
        <input type="text" name="clave" required style="width:100%;padding:6px;"><br><br>
        <button type="submit" style="padding:8px 12px;">Generar Hash</button>
    </form>
</body>
</html>
