<?php
namespace App\Controladores;

use App\Core\ControladorBase;
use App\Core\Sesion;
use App\Modelos\PromocionesModel;

class PromocionesControlador extends ControladorBase
{
    private PromocionesModel $modelo;

    public function __construct()
    {
        parent::__construct();            // inicia sesión y CSRF
        $this->modelo = new PromocionesModel();
    }

    public function index()
    {
        // 1) Usuario actual (o null)
        $user = Sesion::usuario();

        // **DEBUG**: ¿Llega aquí?  
        error_log("Entrando a PromocionesControlador::index – user=" . json_encode($user));

        // 2) Traer todas las promos
        $todas = $this->modelo->getAllPromociones();

        // 3) Normalizar claves y precio para la vista
        foreach ($todas as &$p) {
            $p['clave']  = strtolower($p['codigo']);            // ej: 'NEW','FREQ','VIP' → 'new','freq','vip'
            $p['precio'] = $p['precio_mensual'];                 // precio mensual sólo para VIP
        }
        unset($p);

        // 4) Promo activa de este usuario (registro de usuario_promociones)
        $userPromo = null;
        if ($user) {
            $userPromo = $this->modelo->getPromocionUsuario($user['id_usuario']);
        }

        // 5) Detectar tipo de cliente
        $reservasCount = $user
            ? $this->modelo->contarReservas($user['id_usuario'])
            : 0;
        $isNuevo     = $user && $reservasCount === 0;
        $isFrecuente = $user && $reservasCount >= 10;

        // 6) Llamar a la vista
        $this->vista('Promociones/index', [
            'user'        => $user,
            'todas'       => $todas,
            'userPromo'   => $userPromo,
            'isNuevo'     => $isNuevo,
            'isFrecuente' => $isFrecuente,
            'csrf'        => $_SESSION['csrf_token'] ?? ''
        ]);
    }

    /**
     * Prepara subscripción VIP (antes de redirigir al checkout)
     */
    public function subscribirVip()
    {
        if (! Sesion::estaLogueado()) {
            http_response_code(403);
            echo 'Login requerido';
            return;
        }
        if ($_SERVER['REQUEST_METHOD'] !== 'POST'
            || ! Sesion::verificarCsrf($_POST['csrf_token'] ?? '')
        ) {
            http_response_code(400);
            echo 'Solicitud inválida';
            return;
        }

        $user   = Sesion::Usuario();
        $promos = $this->modelo->getAllPromociones();
        // buscamos la promo 'VIP'
        $vip = array_filter($promos, fn($p) => strtoupper($p['codigo']) === 'VIP');
        if (empty($vip)) {
            die('Promoción VIP no configurada.');
        }
        $promoId = array_column($vip, 'id')[0];
        $this->modelo->subscribirVIP($user['id_usuario'], $promoId);

        // redirigimos de vuelta a la lista
        $this->redirect(BASE_URL . 'promociones');
    }
}