<?php
namespace App\Modelos;

use App\Core\BaseDatos;

class FinanzasModel {
    private $db;

    public function __construct() {
        $this->db = BaseDatos::getInstancia();
    }

    public function filtrarIngresos($desde, $hasta) {
        if ($desde && $hasta) {
            $stmt = $this->db->prepare("SELECT * FROM ingresos WHERE fecha BETWEEN :desde AND :hasta ORDER BY fecha DESC");
            $stmt->execute([
                ':desde' => $desde . ' 00:00:00',
                ':hasta' => $hasta . ' 23:59:59'
            ]);
            return $stmt->fetchAll(\PDO::FETCH_ASSOC);
        }
        return $this->db->query("SELECT * FROM ingresos ORDER BY fecha DESC")->fetchAll(\PDO::FETCH_ASSOC);
    }

    public function filtrarEgresos($desde, $hasta) {
        if ($desde && $hasta) {
            $stmt = $this->db->prepare("SELECT * FROM egresos WHERE fecha BETWEEN :desde AND :hasta ORDER BY fecha DESC");
            $stmt->execute([
                ':desde' => $desde . ' 00:00:00',
                ':hasta' => $hasta . ' 23:59:59'
            ]);
            return $stmt->fetchAll(\PDO::FETCH_ASSOC);
        }
        return $this->db->query("SELECT * FROM egresos ORDER BY fecha DESC")->fetchAll(\PDO::FETCH_ASSOC);
    }
}
