<?php
namespace App\Modelos;

use App\Core\ModeloBase;
use PDO;
use PDOException;

class PromocionesModel extends ModeloBase
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Trae todas las promociones definidas en la tabla.
     */
    public function getAllPromociones(): array
    {
        $sql = "SELECT id, codigo, nombre, descripcion, beneficios, precio_mensual
                FROM promociones
                ORDER BY id";
        return $this->db->query($sql, PDO::FETCH_ASSOC)->fetchAll();
    }

    /**
     * Recupera la promoción activa de un usuario, si existe.
     */
    public function getPromocionUsuario(int $usuarioId): ?array
    {
        $sql = "SELECT up.*, p.codigo, p.nombre, p.descripcion, p.beneficios, p.precio_mensual
                FROM usuario_promociones up
                JOIN promociones p ON p.id = up.promocion_id
                    WHERE up.usuario_id = :uid
                    AND up.activo = 1
                LIMIT 1";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([':uid' => $usuarioId]);
        $r = $stmt->fetch(PDO::FETCH_ASSOC);
        return $r ?: null;
    }

    /**
     * Cuenta cuántas reservas ha hecho el usuario (para determinar cliente frecuente).
     */
    public function contarReservas(int $usuarioId): int
    {
        $sql = "SELECT COUNT(*) FROM reservas WHERE id_cliente = :uid";
        $stmt = $this->db->prepare($sql);
        $stmt->execute([':uid' => $usuarioId]);
        return (int) $stmt->fetchColumn();
    }

    /**
     * Inserta o reactiva la suscripción VIP (precio_mensual).
     */
    public function subscribirVIP(int $usuarioId, int $promocionId): bool
    {
        try {
            $sql = "INSERT INTO usuario_promociones
                        (usuario_id, promocion_id, activo, suscripcion_desde)
                    VALUES
                        (:uid, :pid, 1, CURDATE())
                    ON DUPLICATE KEY UPDATE
                        activo = 1,
                        suscripcion_desde = IF(suscripcion_desde IS NULL, CURDATE(), suscripcion_desde),
                        suscripcion_hasta = NULL";
            $stmt = $this->db->prepare($sql);
            return $stmt->execute([
                ':uid' => $usuarioId,
                ':pid' => $promocionId
            ]);
        } catch (PDOException $e) {
            error_log("Error subscr VIP: ".$e->getMessage());
            return false;
        }
    }
}