<?php include __DIR__ . '/../layout/sidebar.php'; ?>
<?php include __DIR__ . '/../layout/encabezado.php'; ?>

<div class="contenedor-inventario">
    <a href="<?= BASE_URL ?>inventario" class="btn-volver">← Volver</a>
    <h2>🚚 Registrar Movimiento de Insumo</h2>

    <form method="POST" class="formulario-inventario" onsubmit="return confirmarEnvio();">
        <label>Insumo:</label>
        <select name="id_insumo" required>
            <?php foreach ($insumos as $insumo): ?>
                <option value="<?= $insumo['id_insumo'] ?>"><?= htmlspecialchars($insumo['nombre']) ?></option>
            <?php endforeach; ?>
        </select>

        <label>Tipo:</label>
        <select name="tipo" required>
            <option value="entrada">Entrada</option>
            <option value="salida">Salida</option>
        </select>

        <label>Cantidad:</label>
        <input type="number" step="0.01" name="cantidad" required>

        <label>Fecha:</label>
        <input type="date" name="fecha" required>

        <label>Descripción:</label>
        <textarea name="descripcion" rows="3" required></textarea>

        <button type="submit" class="btn-guardar">Guardar Movimiento</button>
    </form>
</div>

<link rel="stylesheet" href="<?= BASE_URL ?>assets/css/inventario.css">
<script src="<?= BASE_URL ?>assets/js/inventario.js"></script>
<link rel="stylesheet" href="<?= BASE_URL ?>assets/css/insumos.css">
<script src="<?= BASE_URL ?>assets/js/insumos.js"></script>