<?php include __DIR__ . '/../layout/sidebar.php'; ?>
<?php include __DIR__ . '/../layout/encabezado.php'; ?>

<div class="contenedor">
    <h2 class="titulo">🚚 Movimientos de Insumos</h2>

    <div style="text-align: right; margin-bottom: 20px;">
        <form method="GET" style="display:inline-block;">
            <label>Mes:</label>
            <select name="mes">
                <?php for ($i=1; $i<=12; $i++): ?>
                    <option value="<?= $i ?>" <?= (isset($mes) && $mes == $i) ? 'selected' : '' ?>><?= str_pad($i, 2, '0', STR_PAD_LEFT) ?></option>
                <?php endfor; ?>
            </select>
            <label>Año:</label>
            <select name="anio">
                <?php $actual = date('Y'); for ($y=$actual; $y>=($actual-5); $y--): ?>
                    <option value="<?= $y ?>" <?= (isset($anio) && $anio == $y) ? 'selected' : '' ?>><?= $y ?></option>
                <?php endfor; ?>
            </select>
            <button type="submit" class="btn crear" style="padding: 6px 14px;">Filtrar</button>
        </form>
        <a href="<?= BASE_URL ?>inventario/crearMovimiento" class="btn crear" style="margin-left: 12px;">+ Registrar Movimiento</a>
    </div>

    <?php if (empty($movimientos)): ?>
        <p class="mensaje-alerta">No hay movimientos registrados.</p>
    <?php else: ?>
        <table class="tabla-inventario">
            <thead>
                <tr>
                    <th>Insumo</th>
                    <th>Tipo</th>
                    <th>Cantidad</th>
                    <th>Fecha</th>
                    <th>Descripción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($movimientos as $m): ?>
                <tr>
                    <td><?= htmlspecialchars($m['insumo']) ?></td>
                    <td><span class="badge <?= $m['tipo'] === 'entrada' ? 'badge-entrada' : 'badge-salida' ?>">
                        <?= htmlspecialchars($m['tipo']) ?></span></td>
                    <td><?= htmlspecialchars($m['cantidad']) ?></td>
                    <td><?= htmlspecialchars($m['fecha']) ?></td>
                    <td><?= htmlspecialchars($m['descripcion']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<link rel="stylesheet" href="<?= BASE_URL ?>assets/css/inventario.css">
<script src="<?= BASE_URL ?>assets/js/inventario.js"></script>
