<?php
    use App\Core\Sesion;
    /** @var array|null $user */
    /** @var array    $todas */
    /** @var array|null $userPromo */
    /** @var bool     $isNuevo */
    /** @var bool     $isFrecuente */
    /** @var string   $csrf */
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Promociones | Chaxras</title>
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/header.css?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/promociones.css?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/footer.css?v=<?= time() ?>">
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/general.css?v=<?= time() ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    </head>
    <body>

    <?php include_once __DIR__ . '/../layout/header.php'; ?>

    <main class="container promociones-page">
    <h1>Promociones</h1>

    <?php if (!$user): ?>
        <div class="alert alert-info">
        <i class="bi bi-info-circle"></i>
        Por favor <a href="<?= BASE_URL ?>login">inicia sesión</a> para ver y acceder a tus promociones.
        </div>
    <?php endif; ?>

    <div class="promos-grid">
        <?php foreach ($todas as $promo): ?>
        <?php
            $activo = $userPromo && $userPromo['promocion_id'] == $promo['id'];
            $badge  = '';
            if ($promo['clave'] === 'new'  && $isNuevo)     $badge = '¡Eres Cliente Nuevo!';
            if ($promo['clave'] === 'freq' && $isFrecuente) $badge = '¡Eres Cliente Frecuente!';
            if ($promo['clave'] === 'vip'  && $activo)      $badge = '¡Eres Cliente VIP!';
        ?>
        <div class="promo-card <?= $activo ? 'activo' : '' ?>">
            <h2><?= htmlspecialchars($promo['nombre']) ?></h2>
            <p><?= nl2br(htmlspecialchars($promo['descripcion'])) ?></p>

            <!-- NUEVO BLOQUE: Beneficios -->
            <?php if (!empty($promo['beneficios'])): ?>
            <h4>Beneficios:</h4>
            <ul class="promo-beneficios">
                <?php
                // Separa por saltos de línea
                $items = preg_split('/\r\n|\r|\n/', trim($promo['beneficios']));
                foreach ($items as $b): 
                ?>
                <li><?= htmlspecialchars($b) ?></li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>

            <?php if ($badge): ?>
            <div class="badge"><?= $badge ?></div>
            <?php endif; ?>

            <!-- Suscripción VIP -->
            <?php if ($promo['clave'] === 'vip' && $user && ! $activo): ?>
            <form method="POST" action="<?= BASE_URL ?>promociones/subscribirVip">
                <input type="hidden" name="csrf_token" value="<?= $csrf ?>">
                <button type="submit" class="btn btn-primary">
                Suscribirme VIP S/. <?= number_format($promo['precio'], 2) ?>
                </button>
            </form>
            <?php endif; ?>

        </div>
        <?php endforeach; ?>
    </div>
    </main>

    <footer class="footer">
            <div class="footer-container">
                <div class="footer-brand">
                    <a href="#">
                        <img src="<?= BASE_URL?>assets/img/logo3.png" alt="Logo Chaxras">
                    </a>  
                    <hr>
                    <h4>Formas de pago</h4>
                    <div class="payment-methods">
                        <i class="fab fa-cc-mastercard"></i>
                        <i class="fab fa-cc-visa"></i>
                        <i class="fab fa-cc-amex"></i>
                        <i class="fab fa-paypal"></i>
                        <i class="fab fa-cc-amazon-pay"></i>
                    </div>
                </div>

                <div class="footer-section">
                    <h4>Categorías</h4>
                    <ul>
                        <li>Frutas y verduras</li>
                        <li>Abarrotes</li>
                        <li>Granos y semillas</li>
                        <li>Aves y cárnicos</li>
                        <li>Lácteos</li>
                        <li>Embutidos</li>
                        <li>Despensas</li>
                    </ul>
                </div>

                <div class="footer-section">
                    <h4>Servicios</h4>
                    <ul>
                        <li>Selección</li>
                        <li>Piqueo</li>
                        <li>Lavado y desinfectado</li>
                        <li>Pelado y procesado</li>
                        <li>Despensa</li>
                    </ul>
                </div>

                <div class="footer-section">
                    <h4>Contacto</h4>
                    <p><i class="fas fa-map-marker-alt"></i> 6448+F24, Chiclayo 14000</p>
                    <p><i class="fas fa-phone-alt"></i> +51 987 654 321</p>
                    <p><i class="fas fa-phone-alt"></i> (051) 123 456</p>
                    <p><i class="fas fa-envelope"></i> info@marketprimavera.com</p>
                    <p><i class="fas fa-globe"></i> www.marketprimavera.com</p>
                </div>

                <div class="footer-section">
                    <h4>Legales</h4>
                    <ul>
                        <li>Términos y condiciones</li>
                        <li>Políticas de privacidad</li>
                        <li>Políticas de cambios</li>
                    </ul>
                    <br>
                    <h4>Redes Sociales</h4>
                    <div class="social-icons">
                        <a href="#"><i class="fab fa-facebook-f"></i></a>
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <p>© 2024 Market Primavera. Todos los derechos reservados.</p>
            </div>
        </footer>

    </body>

    <script>
document.addEventListener('DOMContentLoaded', () => {
    const avatar    = document.getElementById('userAvatar');
    const dropdown  = document.getElementById('userDropdown');
    const logoutBtn = dropdown.querySelector('a[href$="logout"]');

    // Toggle del menú al hacer clic en el avatar
    avatar?.addEventListener('click', e => {
    e.stopPropagation();
    dropdown.classList.toggle('open');
    });

    // Cerrar dropdown al hacer clic fuera
    document.addEventListener('click', () => {
    dropdown.classList.remove('open');
    });

    // Tras hacer clic en Cerrar sesión, forzar recarga
    logoutBtn?.addEventListener('click', () => {
      // Este timeout da tiempo a que el servidor destruya la sesión y redirija
    setTimeout(() => {
        window.location.href = window.location.origin + window.location.pathname;
    }, 100);
    });
});
</script>
    </html>