<?php
require_once '../../app/Modelos/ReservasModel.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    echo json_encode(['status' => 'error', 'detail' => 'Entrada inválida']);
    exit;
}

// Datos de tarjeta
$cardNumber = trim($input['tarjeta'] ?? '');
$expMes     = trim($input['exp_mes'] ?? '');
$expAnio    = trim($input['exp_anio'] ?? '');
$cvv        = trim($input['cvv'] ?? '');
$email      = trim($input['email'] ?? '');
$nombre     = trim($input['nombre'] ?? '');
$monto      = floatval($input['monto'] ?? 0);
$resumen    = $input['datosReserva'] ?? [];

if (!$cardNumber || !$expMes || !$expAnio || !$cvv || !$email || !$nombre || $monto <= 0) {
    echo json_encode(['status' => 'error', 'detail' => 'Datos de pago incompletos']);
    exit;
}

// VALIDACIONES REALES
// 1. Tarjeta bloqueada si termina en 0000
if (substr($cardNumber, -4) === '0000') {
    echo json_encode(['status' => 'rejected', 'detail' => 'Pago rechazado por tarjeta bloqueada']);
    exit;
}

// 2. CVV debe ser de 3 dígitos
if (!preg_match('/^\d{3}$/', $cvv)) {
    echo json_encode(['status' => 'rejected', 'detail' => 'CVV inválido']);
    exit;
}

// 3. Fecha de expiración
$mes = (int)$expMes;
$anio = (int)('20' . $expAnio);
$ahora = getdate();

if ($anio < $ahora['year'] || ($anio == $ahora['year'] && $mes < $ahora['mon'])) {
    echo json_encode(['status' => 'rejected', 'detail' => 'Tarjeta expirada']);
    exit;
}

// ✅ Si todo está correcto, registrar la reserva
$modelo = new \App\Modelos\ReservasModel();

$codigo = 'RSV-' . strtoupper(uniqid());
$datos = [
    'id_cliente'   => $_SESSION['user_id'] ?? null,
    'tipo'         => 'estandar',
    'fecha'        => $resumen['fecha'] ?? date('Y-m-d'),
    'hora'         => $resumen['hora'] ?? '00:00:00',
    'personas'     => intval($resumen['personas'] ?? 1),
    'titular'      => trim($resumen['titular'] ?? ''),
    'alergias'     => trim($resumen['alergias'] ?? ''),
    'celebracion'  => trim($resumen['celebracion'] ?? ''),
    'requerimientos_adicionales' => trim($resumen['req_extra'] ?? ''),
    'monto'        => $monto,
    'estado'       => 'confirmado',
    'codigo'       => $codigo,
    'fecha_creacion' => date('Y-m-d H:i:s')
];

$reservaId = $modelo->crearReserva($datos);
$modelo->registrarIngreso('estandar', $reservaId, $monto);
$modelo->bloquearSlot($datos['fecha'], $datos['hora']);

echo json_encode(['status' => 'approved', 'codigo' => $codigo]);
